﻿const osobe = [];

class Automobil {
    constructor() {
        this.marka = "";
        this.datumKupnje = new Date();
    }

    danaOdKupnje() {
        const danMS = 24 * 60 * 60 * 1000; //Broj milisekundi u jednom danu
        const danas = new Date();
        const razlikaMS = danas.getTime() - this.datumKupnje.getTime(); //Pretvara datum u milisekunde od 1. siječnja 1970.
        return Math.floor(razlikaMS / danMS);
    }

    danKupnje() {
        const dani = ["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"];
        return dani[this.datumKupnje.getDay()]; //pronalazi dan u tjednu kada je automobil kupljen
    }
}

class Osoba {
    constructor() {
        this.punoIme = "";
        this.datumRodjenja = new Date();
        this.automobil = new Automobil();
    }

    ime() {
        return this.punoIme.split(" ")[0];
    }

    godineNaDanKupnjeAutomobila() {
        const godinaMS = 365 * 24 * 60 * 60 * 1000; //broj milisekundi u jednoj godini, računajući 365 dana (bez prijestupne godine)
        const razlikaMS = this.automobil.datumKupnje.getTime() - this.datumRodjenja.getTime();
        return Math.floor(razlikaMS / godinaMS); //dobiva se broj godina
    }
}

function dohvatiAutomobil() {
    const automobil = new Automobil();
    automobil.marka = prompt("Marka automobila koju osoba posjeduje:", "VW");
    automobil.datumKupnje = dohvatiDatum(prompt("Dan kupnje (dd.mm.yyyy):", "01.01.1970"));
    return automobil;
}

function dohvatiOsobu() {
    const osoba = new Osoba();
    osoba.punoIme = prompt("Ime i prezime:", "Pero Perić");
    osoba.datumRodjenja = dohvatiDatum(prompt("Datum rođenja (dd.mm.yyyy):", "01.01.1970"));
    osoba.automobil = dohvatiAutomobil();

    if (osoba.godineNaDanKupnjeAutomobila() < 18) {
        throw new RangeError("Automobil može kupiti samo punoljetna osoba.");
    }
    return osoba;
}

function dohvatiDatum(input) {
    const [dan, mjesec, godina] = input.split(".").map(Number);
    return new Date(godina, mjesec - 1, dan);
}

function zapocni() {
    do {
        try {
            osobe.push(dohvatiOsobu());
        } catch (error) {
            alert(`${error.name}: ${error.message}`);
        }
    } while (confirm("Dodati još osoba?"));
    ispisiSvePodatke();
}

function informacijeOsobe(osoba) {
    const ime = osoba.ime();
    return `${ime} je kupio automobil na dan: ${osoba.automobil.danKupnje().toLowerCase()}, prije ${osoba.automobil.danaOdKupnje()} dana.\n` +
           `Na dan kupnje ${ime} je imao ${osoba.godineNaDanKupnjeAutomobila()} godina.\n\n`;
}

function ispisiSvePodatke() {
    let ispis = "";
    osobe.forEach(osoba => {
        ispis += informacijeOsobe(osoba);
    });
    alert(ispis);
}

zapocni();
